% hamfieldplots plots E-fields and potential for verification.
% 
% hamfieldplot(z1,iteration)
%
% HG 2012-01-13

function hamfieldplot(z1,iteration)

inputham;

if nargin<2
  iteration=0;
  if nargin<1
    z1=mean([zmin zmax]);
  end
end

rEarth = 6371.2e3;       % Radius of the earth [m]

Lx=xmax-xmin;
Ly=ymax-ymin;
Lz=zmax-zmin;
dV=Lx*Ly*Lz/((Nx-1)*(Ny-1)*(Nz-1));

% axes
x=xmin+[0:Nx-1]*Lx/(Nx-1); dx=x(2)-x(1);
y=ymin+[0:Ny-1]*Ly/(Ny-1); dy=y(2)-y(1);
z=zmin+[0:Nz-1]*Lz/(Nz-1); dz=z(2)-z(1);

Nmidz=round((z1-zmin)/dz+1);

% Assemble filenames
phi = ['phi_',num2str(iteration,'%0.4d') '.ham.mat'];
E = ['Efi_',num2str(iteration,'%0.4d') '.ham.mat'];


% Load potential
load(phi)

% Load electric field
load(E)
figure(1)
set(gcf,'paperpositionmode','auto','renderer','zbuffer')
Emax=max(max(max(Ex(:,:,Nmidz))));
Emin=min(min(min(Ex(:,:,Nmidz))));
pp=[];pp(:,:)=Ex(:,:,Nmidz);
pp(isnan(pp))=Emax+1e16;
ss=size(pp);
pp=[pp zeros(ss(1),1);zeros(1,ss(2)+1)];
xplot=[xmin-0.5*dx (x+0.5*dx)];
yplot=[ymin-0.5*dy (y+0.5*dy)];
surf(xplot,yplot,pp)
view(2)
set(gca,'fontname','times','fontsize',14)
% $$$ set(gca,'xdir','reverse')
shading flat
view(2)
axis equal
axis([min(xplot) max(xplot) min(yplot) max(yplot)])
hh=colorbar;
set(hh,'fontname','times','fontsize',16)
xlabel('x','fontname','times','fontsize',16)
ylabel('y','fontname','times','fontsize',16)
title(['E_{x} at z=' num2str(z(Nmidz)) 'm'],'fontname','times','fontsize',16)
cc=colormap(jet(64));
cc=[cc;1 1 1];sc=size(cc);colormap(cc);
caxis([Emin Emax+(Emax-Emin)/(sc(1)-1)+1e-10])
% earthly circle
fi=[0:360]*pi/180;
zz=rEarth*real(cos(asin(z(Nmidz)/rEarth)))*exp(1i*fi);
hold on
plot3(real(zz),imag(zz),ones(size(fi))*Emax*20+1e20,'k')
hold off

figure(2)
set(gcf,'paperpositionmode','auto','renderer','zbuffer')
Emax=max(max(max(Ey(:,:,Nmidz))));
Emin=min(min(min(Ey(:,:,Nmidz))));
pp=[];pp(:,:)=Ey(:,:,Nmidz);
pp(isnan(pp))=Emax+1e16;
ss=size(pp);
pp=[pp zeros(ss(1),1);zeros(1,ss(2)+1)];
xplot=[xmin-0.5*dx (x+0.5*dx)];
yplot=[ymin-0.5*dy (y+0.5*dy)];
surf(xplot,yplot,pp)
view(2)
set(gca,'fontname','times','fontsize',14)
% $$$ set(gca,'xdir','reverse')
shading flat
view(2)
axis equal
axis([min(xplot) max(xplot) min(yplot) max(yplot)])
hh=colorbar;
set(hh,'fontname','times','fontsize',16)
xlabel('x','fontname','times','fontsize',16)
ylabel('y','fontname','times','fontsize',16)
title(['E_{y} at z=' num2str(z(Nmidz)) 'm'],'fontname','times','fontsize',16)
cc=colormap(jet(64));
cc=[cc;1 1 1];sc=size(cc);colormap(cc);
caxis([Emin Emax+(Emax-Emin)/(sc(1)-1)+1e-10])
% earthly circle
fi=[0:360]*pi/180;
zz=rEarth*real(cos(asin(z(Nmidz)/rEarth)))*exp(1i*fi);
hold on
plot3(real(zz),imag(zz),ones(size(fi))*Emax*20+1e20,'k')
hold off

figure(3)
set(gcf,'paperpositionmode','auto','renderer','zbuffer')
Emax=max(max(max(Ez(:,:,Nmidz))));
Emin=min(min(min(Ez(:,:,Nmidz))));
pp=[];pp(:,:)=Ez(:,:,Nmidz);
ss=size(pp);
pp=[pp zeros(ss(1),1);zeros(1,ss(2)+1)];
pp(isnan(pp))=Emax+1e16;
xplot=[xmin-0.5*dx (x+0.5*dx)];
yplot=[ymin-0.5*dy (y+0.5*dy)];
surf(xplot,yplot,pp)
view(2)
set(gca,'fontname','times','fontsize',14)
% $$$ set(gca,'xdir','reverse')
shading flat
view(2)
axis equal
axis([min(xplot) max(xplot) min(yplot) max(yplot)])
hh=colorbar;
set(hh,'fontname','times','fontsize',16)
xlabel('x','fontname','times','fontsize',16)
ylabel('y','fontname','times','fontsize',16)
title(['E_{z} at z=' num2str(z(Nmidz)) 'm'],'fontname','times','fontsize',16)
cc=colormap(jet(64));
cc=[cc;1 1 1];sc=size(cc);colormap(cc);
caxis([Emin Emax+(Emax-Emin)/(sc(1)-1)+1e-10])
% earthly circle
fi=[0:360]*pi/180;
zz=rEarth*real(cos(asin(z(Nmidz)/rEarth)))*exp(1i*fi);
hold on
plot3(real(zz),imag(zz),ones(size(fi))*Emax*20+1e20,'k')
hold off

figure(4)
set(gcf,'paperpositionmode','auto','renderer','zbuffer')
phimax=max(max(max(phi(:,:,Nmidz))));
phimin=min(min(min(phi(:,:,Nmidz))));
pp=[];pp(:,:)=phi(:,:,Nmidz);
pp(isnan(pp))=phimax+1e16;
ss=size(pp);
pp=[pp zeros(ss(1),1);zeros(1,ss(2)+1)];
xplot=[xmin-0.5*dx (x+0.5*dx)];
yplot=[ymin-0.5*dy (y+0.5*dy)];
surf(xplot,yplot,pp)
view(2)
set(gca,'fontname','times','fontsize',14)
% $$$ set(gca,'xdir','reverse')
shading flat
view(2)
axis equal
axis([min(xplot) max(xplot) min(yplot) max(yplot)])
hh=colorbar;
set(hh,'fontname','times','fontsize',16)
xlabel('x','fontname','times','fontsize',16)
ylabel('y','fontname','times','fontsize',16)
title(['phi at z=' num2str(z(Nmidz)) 'm'],'fontname','times','fontsize',16)
cc=colormap(jet(64));
cc=[cc;1 1 1];sc=size(cc);colormap(cc);
caxis([phimin phimax+(phimax-phimin)/(sc(1)-1)+1e-10])


% earthly circle
fi=[0:360]*pi/180;
zz=rEarth*real(cos(asin(z(Nmidz)/rEarth)))*exp(1i*fi);
hold on
plot3(real(zz),imag(zz),ones(size(fi))*phimax*20+1e20,'k')
hold off

